var Recipe = Backbone.Model.extend({
    defaults: {
        title: "Neues Rezept",
        ingredients: "",
        instructions: ""
    }
});

var Cookbook = Backbone.Collection.extend({
    model: Recipe
});

var NavigationView = Backbone.View.extend({
    events: {
        'click a': 'navigate'
    },

    navigate: function(el) {
        Backbone.history.navigate($(el.target).attr('href'), { trigger: true });
        return false;
    }
});


var RecipeView = Backbone.View.extend({
    template: _.template($('#template-recipe').html()),
    render: function() {
        this.$el.html(this.template(this.model.toJSON()));
        return this;
    }
});

var ListView = Backbone.View.extend({
    tagName: 'ul',
    events: {
        'click a': 'navigate'
    },
    template: _.template($('#template-list-empty').html()),
    render: function () {
        if (this.model.length) {
            this.model.each(function (recipe) {
                this.$el.append(new ListViewItem({ model: recipe }).render().el);
            }, this);
        } else {
            this.$el.append(this.template());
        }
        return this;
    },
    navigate: function(el) {
        Backbone.history.navigate($(el.target).attr('href'), { trigger: true });
        return false;
    }
});

var ListViewItem = Backbone.View.extend({
    tagName: 'li',
    template: _.template($('#template-list').html()),
    render: function() {
        this.$el.html(this.template(this.model.toJSON()));
        return this;
    }
});

var EditView = Backbone.View.extend({
    // Cache the template function for a single item.
    template: _.template($('#template-edit').html()),

    events: {
        'click input[type="submit"]': 'save'
    },

    save: function() {
        this.model.set({
            title: this.$el.find('#title').val(),
            ingredients: this.$el.find('#ingredients').val(),
            instructions: this.$el.find('#instructions').val()
        });
        this.trigger('finished');
        return false;
    },

    render: function() {
        this.$el.html(this.template(this.model.toJSON()));
        return this;
    }
});

var CookbookApp = Backbone.Router.extend({
    routes: {
        '': 'home',
        'recipe/add': 'add',
        'recipe/:id': 'display'
    },

    view: null,

    highestID: 0,

    initialize: function() {
        this.cookbook = new Cookbook();
    },

    switchView: function(view) {
        if (this.view) {
            if (this.view.destroy) {
                this.view.destroy();
            }
            this.view = null;
        }
        this.view = view;
        $('#main').empty().append(view.render().el);
        return view;
    },

    home: function() {
        this.switchView(new ListView({ model: this.cookbook }));
        $('#navigation .active').removeClass('active');
        $('#navigation [href="/"]').parent('li').addClass('active');
    },

    add: function() {
        var app = this;
        this.switchView(new EditView({
            model: new Recipe({
                id: ++this.highestID
            })
        }));
        $('#navigation .active').removeClass('active');
        $('#navigation [href="/recipe/add"]').parent('li').addClass('active');
        this.view.on('finished', function() {
            app.cookbook.add(this.model);
            Backbone.history.navigate('/', { trigger: true });
        });
    },

    display: function(id) {
        this.switchView(new RecipeView({
            model: this.cookbook.get(id)
        }));
    }
});

$(function() {
    var nav = new NavigationView({ el: $('#navigation') });
    var app = new CookbookApp();
    Backbone.history.start();
});
