<?php
// Header setzen
header("Content-Type: text/html; charset=utf-8");

/**
 *  PEAR HTML_QuickForm2 Vorlage, erweitert
 *
 *  @license  JUST-DO-WHAT-EVER-YOU-LIKE-BUT-DONT-BLAME-ME Licence ;-)
 *  @link     http://webkrauts.de
 */

/**
 *  Als erstes wird die Library eingebunden. Der Pfad zur Library muss
 *  im PHP include_path (http://www.php.net/manual/de/ini.core.php#ini.include-path)
 *  vorhanden sein. Um einen Renderer explizit anzusprechen, wird noch die
 *  Library Renderer Klasse referenziert.
 */
require_once 'HTML/QuickForm2.php';
require_once 'HTML/QuickForm2/Renderer.php';

/**
 *  Wir bilden eine Instanz des Renderes. In unseren Falle 
 *  rufen wir einfach den Standard Renderer explizit auf.
 *  
 */
$renderer = HTML_QuickForm2_Renderer::factory('default');

/**
 *  Wir haben nun Zugriff auf Methoden der Renderer Klasse. Hier
 *  definieren wir den Pflichtfeld Hinweis, der ohne Angabe
 *  in englischer Sprache ausgegeben wird. Der zweite Parameter
 *  entspricht der Standardeinstellung, die besagt, dass Fehlermeldungen
 *  direkt an den entsprechenden Feldern ausgeben wird. Setzen wir hier
 *  ein "true", werden die Fehler oberhalb des Formulars als gruppierte
 *  Liste angezeigt.
 */
$renderer->setOption(array(
    'required_note' => 'Mit einem * ausgezeichnete Felder sind Pflichtfelder',
		'group_errors' => false
));

/**
 *  Wir legen ein neues Formular an, in dem wir
 *  eine neue Instanz der Hauptklasse ableiten
 */
$FORM = new HTML_QuickForm2('tutorial');


/**
 *  Die Attributvergabe bei den folgenden Element-Deklarationen sind allesamt
 *  willkürlich und können grundsätzlich bei jeden Input-Typ angewandt werden
 *  Dort, wo dies nicht der Fall, wird dies erwähnt.
 */

/**
 *  HTML5-Input-Feld vom Typ 'email'
 */
$email = $FORM->addElement('email', 'email',
  array('id' => 'email', 'class' => 'form-input', 'required', 'aria-required' => 'true'),
  array('label' => 'Ihre E-Mail-Adresse')
);
/**
 *  Wir wenden zwei Regeln (Auszeichnung als Pflichtfeld, 
 *  Prüfung auf syntaktisch korrekten Inhalt) auf unser Element an
 *  Diese Regeln werden server-seitig ausgeführt.
 */
$email->addRule('required', 'Bitte tragen Sie eine E-Mail Adresse ein');
$email->addRule('email', 'Bitte überprüfen Sie die angegebene E-Mail-Adresse');


/**
 *  HTML5-Input-Feld vom Typ 'text'
 */
$plz = $FORM->addElement('text', 'plz', 
	array('id' => 'plz', 'autofocus', 'pattern' => '[0-9]{5}'),
	array('label' => 'PLZ')
);
/**
 *  Mit der QF2-Regel wird im Grunde die Browservalidierung ('pattern') serverseitig nachgestellt.
 *  HTML5-Valdierung funktioniert nur in wenigen Browsern. Deswegen ist die
 *  die server-seitige Überprüfung der Werte zwingend notwendig!
 *  
 *  Es wird geprüft, ob das Feld exakt 5 Ziffern beinhaltet.
 *  Diese Regel wird server-seitig ausgeführt.
 */
$plz->addRule('regex', 'Die PLZ muss exakt aus 5 Ziffern bestehen', '=^([0-9]+){5}$=D');


/**
 *  HTML5-Input-Feld vom Typ 'url'
 */
$url = $FORM->addElement('url', 'url', 
	array('id' => 'url', 'placeholder' => 'http://...'),
	array('label' => 'Ihre Homepage')
);


/**
 *  HTML5-Input-Feld vom Typ 'number'
 */
$url = $FORM->addElement('number', 'children', 
	array('id' => 'children', 'min' => 5, 'max' => 10),
	array('label' => 'Ich habe x Kinder')
);


/**
 *  HTML5-Input-Feld vom Typ 'tel'
 */
$phone = $FORM->addElement('tel', 'phone', 
	array('id' => 'phone'),
	array('label' => 'Ihre Telefonnummer')
);
/**
 *  Es wird geprüft, ob die Angaben im Feld einer bestimmten Form entsprechen.
 *  Diese Regel wird server-seitig ausgeführt.
 */
$phone->addRule('regex', 'Bitte überprüfen sie Ihre Angabe. Erlaubte Zeichen: Zahlen, Pluszeichen', '=^([0-9\s\+])+$=Di');


/**
 *  Unser Submit-Button
 */
$FORM->addElement('submit', 'submit', array('id' => 'submit','value' => 'Send'));


/**
 *  Wir können mit folgender Funktion rekursiv alle übertragenen Werte
 *  von Leerzeichen am Anfang/Ende der Angabe befreien. Dies
 *  ist sinnvoll, um in Weiterverarbeitung 'saubere' Werte zu haben
 */
$FORM->addRecursiveFilter('trim');


/**
 *  Vorbelegung beliebiger Elemente ist mit nachfolgender Methode möglich.
 *  Hier im Beispiel soll das Feld 'plz' bei Aufruf des Formulars
 *  den Standardwert '12345' haben.
 */
$FORM->addDataSource(new HTML_QuickForm2_DataSource_Array(array(
    'plz' => '12345'
)));


/**
 *  Wenn das Formular alle Regeln erfolgreich durchlaufen hat
 *  und über Klick auf den Submit-Button abgeschickt wurde, zeige
 *  die Erfolgsmeldung und den Wert des übertragenen Elementes.
 *  Andernfalls zeige die gerenderte Ausgabe des Formular an.
 */
if ($FORM->validate()) {
		echo 'Jo, ist alles durchgegangen'
    exit;
}

/**
 *  Wir übergeben den deklarierten Renderer an eine spezielle Methode ('render()'),
 *  die das Formular für die Ausgabe vorbereitet.
 */
$FORM->render($renderer);

/**
 *  Ausgabe des Formulars
 */
echo $renderer;

?>